<!DOCTYPE html>

<html lang="en" dir="{{ (App\Language::isDefaultLanuageRtl()) ? 'rtl' : 'ltr' }}">



<head>

	<meta charset="utf-8">

	<meta http-equiv="X-UA-Compatible" content="IE=edge">

	<meta name="viewport" content="width=device-width, initial-scale=1">

	<meta name="description" content="{{getSetting('meta_description', 'seo_settings')}}">

	<meta name="keywords" content="{{getSetting('meta_keywords', 'seo_settings')}}">

	 

	<link rel="icon" href="{{IMAGE_PATH_SETTINGS.getSetting('site_favicon', 'site_settings')}}" type="image/x-icon" />

	

	<title>{{ isset($title) ? $title : getSetting('site_title','site_settings') }}</title>



	@yield('header_scripts')

	<!-- Bootstrap Core CSS -->

	<link href="{{CSS}}bootstrap.min.css" rel="stylesheet">



	<!-- Custom CSS -->

	<link href="{{CSS}}sb-admin.css" rel="stylesheet">


	<!-- Morris Charts CSS -->

	<link href="{{CSS}}plugins/morris.css" rel="stylesheet">

    <!-- Custom Fonts -->

    <link href="{{FRONT_ASSETS}}fonts/proxima-nova/proximanova.css" rel="stylesheet">

	<!-- Custom Fonts -->

	<link href="{{CSS}}custom-fonts.css" rel="stylesheet" type="text/css">

	<link href="{{CSS}}materialdesignicons.css" rel="stylesheet" type="text/css">

	<link href="{{FONTAWSOME}}font-awesome.min.css" rel="stylesheet" type="text/css">

	<link href="{{CSS}}sweetalert.css" rel="stylesheet" type="text/css">

	
<style>
.active {
    color: red;
}
</style>

</head>

{{-- class="login-screen" background="bgimage.jpg" --}}


<body class="login-screen" background="{{IMAGE_PATH_SETTINGS.getSetting('background_image','site_settings')}}" ng-app="academia" >

 <!-- NAVIGATION -->
 <div class="login-nav">
    <nav class="navbar navbar-default st-navbar-default navbar-fixed-top">
        <div class="container">
            <div class="navbar-header">
                <a class="navbar-brand page-scroll" href="{{PREFIX}}"><img src="{{IMAGE_PATH_SETTINGS.getSetting('site_logo', 'site_settings')}}" alt="{{getSetting('site_title','site_settings')}}"></a>
                <button type="button" class="navbar-toggle offcanvas-toggle pull-right" data-toggle="offcanvas" data-target="#js-bootstrap-offcanvas">
                    <span class="sr-only">Toggle navigation</span>
                    <span>
                        <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    </span>
                </button>
            </div>
            <div class="navbar-offcanvas navbar-offcanvas-touch" id="js-bootstrap-offcanvas">
                <ul class="nav navbar-nav navbar-right">

                    <li> 
                        <a

                        @if($active_class=='home')
                            class="page-scroll active" 
                        @else
                            class="page-scroll" 
                        @endif

                        href="{{PREFIX}}">Home</a> 
                    </li>


                     <li> 
                        <a

                        @if($active_class=='exams')
                            class="page-scroll active" 
                        @else
                            class="page-scroll" 
                        @endif

                        href="{{URL_FRONTEND_EXAMS_LIST}}">{{getPhrase('practice_exams')}}</a> 
                    </li>

                    <li> 
                        <a 
                        @if($active_class=='terms-conditions')
                            class="page-scroll active" 
                        @else
                            class="page-scroll" 
                        @endif

                        href="{{SITE_PAGES_TERMS}}">Terms and Conditions
                        </a> 
                    </li>
                    <li> 
                        <a 
                        @if($active_class=='privacy-policy')
                            class="page-scroll active" 
                        @else
                            class="page-scroll" 
                        @endif
                        href="{{SITE_PAGES_PRIVACY}}"
                        >Privacy and Policy
                    </a> </li>
                    <li> 

                    	<a  @if($active_class =='login')
                              class="page-scroll active" 
                          @else
                            class="page-scroll" 
                            @endif
                             href="{{URL_USERS_LOGIN}}">Login</a>
                              </li>
                    <li> <a 
                         @if($active_class=='register')
                            class="page-scroll active" 
                        @else
                            class="page-scroll" 
                        @endif
                         href="{{URL_USERS_REGISTER}}">Register</a> 
                     </li>
                </ul>
            </div>
        </div>
    </nav>
</div>
    <!-- /NAVIGATION --> 


	@yield('content')

	



		<!-- /#wrapper -->

		<!-- jQuery -->

		<script src="{{JS}}jquery-1.12.1.min.js"></script>



		<!-- Bootstrap Core JavaScript -->

		<script src="{{JS}}bootstrap.min.js"></script>



		<!-- Morris Charts JavaScript -->

		{{-- <script src="{{JS}}plugins/morris/raphael.min.js"></script> --}}

		{{-- <script src="{{JS}}plugins/morris/morris.min.js"></script>

		<script src="{{JS}}plugins/morris/morris-data.js"></script> --}}

		<!--JS Control-->

		<script src="{{JS}}main.js"></script>

		<script src="{{JS}}sweetalert-dev.js"></script>

		@include('errors.formMessages')

		@yield('footer_scripts')
		
		{!!getSetting('google_analytics', 'seo_settings')!!}
</body>



</html>